package DTCDemo;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

import SDK.SDKlib;
import net.miginfocom.swing.MigLayout;

// ====================================================================================

@SuppressWarnings("serial")
public class HKPreview extends JDialog {

	private JPanel panelHKP = new JPanel();
	private JComboBox<ComboItem> comboHKSlot = new JComboBox<ComboItem>();
	private JLabel label = new JLabel("Slot Number");
	private JLabel HKPreview = new JLabel("");

    private static Image[] HKPImage = new Image[10];
    
	// ====================================================================================

	public HKPreview(JFrame parent, SDKlib SDK, Image[] buff) {
		//Create Dialog
		super(parent, "HoloKote Preview", true);
	    this.setSize(SDK.HKPREVIEW_WIDTH + 30, SDK.HKPREVIEW_HEIGHT + 80);
	    panelHKP.setLayout(new MigLayout("", "[98.00px,grow]", "[20px,grow][]"));

	    //Initialise combo
	    for (Integer i = 1; i <= buff.length; i++)
		{
			comboHKSlot.addItem(new ComboItem(i.toString(), i.byteValue()));
		}
		this.getContentPane().add(panelHKP);
		
		panelHKP.add(HKPreview, "cell 0 0");

		panelHKP.add(label, "flowx,cell 0 1,alignx center,aligny center");
		comboHKSlot.setMaximumRowCount(10);
		panelHKP.add(comboHKSlot, "cell 0 1,alignx left,aligny top");
	    comboHKSlot.addActionListener(new ActionListener(){
	    	public void actionPerformed(ActionEvent e) {
				DisplayBitmap(((ComboItem)comboHKSlot.getSelectedItem()).getValue() - 1);
	    	}
	    });
	    
		//Copy the previews to the local store
	    HKPImage = buff;

	    DisplayBitmap(0);
	    this.setDefaultCloseOperation(DISPOSE_ON_CLOSE);
	    this.setVisible(true);
	}
	
	private void DisplayBitmap(int slot) {
		HKPreview.setIcon(new ImageIcon(HKPImage[slot]));
	}
}
